/*
 * structures for holding map information
 */
#include "symbols.h"

#define DELTA_TO_ROUTE(D) (((D)&0x3F) | 0x80)
#define ROUTE_TO_DELTA(R) (((unsigned char)(R)>0x90)?((R)-0xC0):((R)-0x80))

/* type of thing attach to an xbar port */
enum {
 CONN_XBAR,	/* another crossbar */
 CONN_HOST,	/* a host */
 CONN_NULL
};

#define MAX_HOSTNAME_LEN 64
#define MAX_XBAR_PORT 32
#define MAX_HOST_PORT 2

struct xbar {
  char name[16]; /* name from map file */
  int id;        /* xbar Id (valid for xbar32's only) */
  int nport;     /* ports on this xbar */
  int firstport; /* first connected port */

  struct xbport {
    char conn_type;	/* CONN_XBAR, CONN_HOST, or CONN_NULL */
    char conn_port;	/* port # of next xbar if CONN_XBAR */
    union {
      struct xbar *x;
      struct hostport *hp;
    } ptr;		/* ptr to xbar or host */

    /* some variables used by the link walker */
    int tested;		/* the line to/from this has been tested */
    int bad;		/* link tested bad, do not use for extension */

    /* fields used by wire list */

  } port[MAX_XBAR_PORT];

  /* Variables to connect map file to wire list */
  struct slotdesc *sp;	/* slot this xbar occupies */

  unsigned char route[16];	/* route from running node to this xbar */
  int rlen;			/* length of route */
  int visited;			/* set once visited */
  int in_port;			/* port this route comes in */
  struct xbar *route_next;	/* used while building routes */
};


struct hostport {
	int xbport;		/* port on the xbar */
 	struct xbar *xbar;	/* xbar to which this host connects */
	struct host *myhost; /* the host nic that this port is part of */
};

struct host {
  char mapname[16];	/* name from map file */

  int nport;		/* number of ports on this host */

  struct hostport port[MAX_HOST_PORT];

  unsigned char mac_addr[6];    /* MAC address (1/nic, not 1/port) */
  char hostname[MAX_HOSTNAME_LEN];	/* hostname */
};


struct mapfile {
  char *name;
  FILE *fp;

  struct symtab *hsyms;
  struct symtab *xsyms;

  struct host *host;
  int nhost;
  struct xbar *xbar;
  int nxbar;
};

/*
 * Prototypes
 */
void load_map_file(struct mapfile *);
void find_self(struct mapfile *);
void calc_xbar_routes(struct mapfile *);
